/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client;

import com.google.common.collect.ImmutableList;
import dev.ftb.mods.ftbchunks.api.client.FTBChunksClientAPI;
import dev.ftb.mods.ftbchunks.api.client.minimap.MinimapInfoComponent;
import dev.ftb.mods.ftbchunks.api.client.waypoint.WaypointManager;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.client.FTBChunksClientConfig;
import dev.ftb.mods.ftbchunks.client.map.MapDimension;
import dev.ftb.mods.ftbchunks.client.map.MapManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_5321;

public class FTBChunksClientAPIImpl
implements FTBChunksClientAPI {
    private static final List<MinimapInfoComponent> minimapComponents = new ArrayList<MinimapInfoComponent>();

    @Override
    public Optional<WaypointManager> getWaypointManager() {
        return MapDimension.getCurrent().flatMap(d -> Optional.ofNullable(d.getWaypointManager()));
    }

    @Override
    public Optional<WaypointManager> getWaypointManager(class_5321<class_1937> dimension) {
        return MapManager.getInstance().flatMap(manager -> Optional.ofNullable(manager.getDimension(dimension).getWaypointManager()));
    }

    @Override
    public void requestMinimapIconRefresh() {
        FTBChunksClient.INSTANCE.refreshMinimapIcons();
    }

    @Override
    public void registerMinimapComponent(MinimapInfoComponent component) {
        if (minimapComponents.contains(component)) {
            throw new IllegalStateException("Minimap component %s already registered".formatted(component.id()));
        }
        minimapComponents.add(component);
    }

    @Override
    public boolean isMinimapComponentEnabled(MinimapInfoComponent component) {
        return !((List)FTBChunksClientConfig.MINIMAP_INFO_HIDDEN.get()).contains(component.id().toString());
    }

    @Override
    public void setMinimapComponentEnabled(MinimapInfoComponent component, boolean enabled) {
        if (enabled) {
            ((List)FTBChunksClientConfig.MINIMAP_INFO_HIDDEN.get()).remove(component.id().toString());
        } else {
            ((List)FTBChunksClientConfig.MINIMAP_INFO_HIDDEN.get()).add(component.id().toString());
        }
        FTBChunksClientConfig.saveConfig();
        FTBChunksClient.INSTANCE.setupComponents();
    }

    @Override
    public ImmutableList<MinimapInfoComponent> getMinimapComponents() {
        return ImmutableList.copyOf(minimapComponents);
    }
}

